<?php
	include "../inc/connect.inc.php";

	session_start();

	$page = md5("Login Page");

	if (!isset($_SESSION['userID'])) {
		header("Location: ../login/?err=". $page);
	} else {
		$uid = $_SESSION['userID'];
		$access = $_SESSION['Access'];
		$names = $_SESSION['names'];
	}
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Admin Panel</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
	<link rel="stylesheet" href="../assets/css/styles.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>
<body>
	<div class="container mt-5">
		<!-- <div class="row justify-content-left mb-3"> -->
		<div class="row mb-3">
			<div class="col-md-8 col-sm-8 text-start">
				<h5>Welcome <strong><?php echo strtoupper($names); ?></strong></h5>
			</div>
			<div class="col-md-4 col-sm-4 text-end">
				<a href="../inc/logout.inc.php" class="btn btn-danger btn-sm">
					<i class="fa fa-sign-out-alt"></i>
					Logout
				</a>
			</div>
		</div>
		<div class="row justify-content-center">
			<div class="mb-3 mt-2 card">
				<div class="card-body">
					<div class="row">
						<div class="col-md-3 col-sm-3">
							<button type="button" class="btn btn-outline-info w-100 fw-bold" id="users">
								<i class="fa fa-user"></i>
								Users
							</button>
						</div>
						<div class="col-md-3 col-sm-3">
							<button type="button" class="btn btn-outline-info w-100 fw-bold" id="classes">
								<i class="fa fa-edit"></i>
								Classes
							</button>
						</div>
						<div class="col-md-3 col-sm-3">
							<button type="button" class="btn btn-outline-primary w-100 fw-bold" id="exams">
								<i class="fa fa-graduation-cap"></i>
								Exams
							</button>
						</div>
					</div>
				</div>
			</div>
			<div class="card mb-3 mt-3">
				<div class="card-body mb-2" id="response"></div>
				<div class="card-body mb-2 mt-2" id="errMsg"></div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="mymodal"></div>

	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="../assets/js/jquery.js"></script>
	<script src="../assets/js/joh.js"></script>
</body>
</html>